"""
------------------------------------------------------------------------------- 
Author: Dan64
Date: 2024-10-09
version: 
LastEditors: Dan64
LastEditTime: 2024-10-09
------------------------------------------------------------------------------- 
Description:
------------------------------------------------------------------------------- 
Utility functions to load Vapoursynth plugins dynamically.
"""

import vapoursynth as vs
import os
from PIL import Image

from vsdeoldify.vsslib.vsutils import HAVC_LogMessage, MessageType

from vsdeoldify.vsslib.constants import *

from vsdeoldify.vsslib.__int__ import *

"""
------------------------------------------------------------------------------- 
Author: Dan64
------------------------------------------------------------------------------- 
Description:
------------------------------------------------------------------------------- 
Utility functions to load Vapoursynth plugins dynamically.
"""

def load_Retinex_plugin() -> bool:
    """
    Ensures Retinex VapourSynth plugin is loaded.
    """

    plugin_path = os.path.normpath(os.path.join(Retinex_dir, "Retinex.dll"))

    try:
        if hasattr(vs.core, 'retinex') and hasattr(vs.core.retinex, 'MSRCP'):
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION,f"[INFO] Plugin 'Retinex' already loaded.")
            return True
        else:
            vs.core.std.LoadPlugin(path=plugin_path)
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION, f"[INFO] Plugin 'Retinex' loaded from: {plugin_path}")
            return True
    except Exception as error:
        HAVC_LogMessage(MessageType.WARNING,"[WARNING] Plugin 'Retinex': check/load failed ->", str(error))
        return False

def load_SCDetect_plugin() -> bool:
    """
    Ensures SCDetect VapourSynth plugin is loaded.
    """

    plugin_path = os.path.normpath(os.path.join(MiscFilter_dir, "MiscFilters.dll"))

    try:
        if hasattr(vs.core, 'misc') and hasattr(vs.core.misc, 'SCDetect'):
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION,"[INFO] Plugin 'SCDetect' already loaded.")
            return True
        else:
            vs.core.std.LoadPlugin(path=plugin_path)
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION, f"[INFO] Plugin 'SCDetect' loaded from: {plugin_path}")
            return True
    except Exception as error:
        HAVC_LogMessage(MessageType.WARNING, "[WARNING] Plugin 'SCDetect': check/load failed ->", str(error))
        return False

def load_ReduceFlicker_plugin() -> bool:
    """
    Ensures ReduceFlicker VapourSynth plugin is loaded.
    """

    plugin_path = os.path.normpath(os.path.join(ReduceFlicker_dir, "ReduceFlicker.dll"))

    try:
        if hasattr(vs.core, 'rdfl') and hasattr(vs.core.rdfl, 'ReduceFlicker'):
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION,"[INFO] Plugin 'ReduceFlicker' already loaded.")
            return True
        else:
            vs.core.std.LoadPlugin(path=plugin_path)
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION, f"[INFO] Plugin 'ReduceFlicker' loaded from: {plugin_path}")
            return True
    except Exception as error:
        HAVC_LogMessage(MessageType.WARNING,"[WARNING] Plugin 'ReduceFlicker': check/load failed ->", str(error))
        return False

def load_LSMASHSource_plugin() -> bool:
    """
    Ensures LSMASHSource VapourSynth plugin is loaded.
    """

    plugin_path = os.path.normpath(os.path.join(LSMASHSource_dir, "LSMASHSource.dll"))

    try:
        if hasattr(vs.core, 'lsmas') and hasattr(vs.core.lsmas, 'LWLibavSource'):
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION,"[INFO] Plugin 'LSMASHSource' already loaded.")
            return True
        else:
            vs.core.std.LoadPlugin(path=plugin_path)
            if DEF_DEBUG_LEVEL > DEF_LEVEL_NONE:
                HAVC_LogMessage(MessageType.INFORMATION, f"[INFO] Plugin 'LSMASHSource' loaded from: {plugin_path}")
            return True
    except Exception as error:
        HAVC_LogMessage(MessageType.WARNING,"[WARNING] Plugin 'LSMASHSource': check/load failed ->", str(error))
        return False


"""
------------------------------------------------------------------------------- 
Author: Dan64
------------------------------------------------------------------------------- 
Description:
------------------------------------------------------------------------------- 
Wrapper to ReduceFlicker
"""

def vs_reduce_flicker(clip: vs.VideoNode, strength: int = 2, aggressive: int = 0) -> Image:

    load_ReduceFlicker_plugin()

    try:
        clip = vs.core.rdfl.ReduceFlicker(clip=clip, strength=strength, aggressive=aggressive)
    except Exception as error:
        raise vs.Error("vs_retinex: plugin 'ReduceFlicker.dll' not properly loaded/installed -> " + str(error))

    return clip
