"""
-------------------------------------------------------------------------------
Author: Dan64
Date: 2025-09-28
version:
LastEditors: Dan64
LastEditTime: 2025-09-28
-------------------------------------------------------------------------------
Description: Duplicated instance to allow parallel encoding using "ColorMNet"
             (implemented as Singleton)
-------------------------------------------------------------------------------
main Vapoursynth wrapper for model: "ColorMNet"
URL: https://github.com/yyang181/colormnet
"""
from __future__ import annotations, print_function
#import threading
#import torch
#import os
#import gc
#from functools import partial

#import vapoursynth as vs
from vsdeoldify.colormnet2.colormnet2_render import ColorMNetRender2
from vsdeoldify.colormnet2.colormnet2_utils import *
from vsdeoldify.colormnet2.colormnet2_server import ColorMNetServer2
from vsdeoldify.colormnet2.colormnet2_client import ColorMNetClient2
from vsdeoldify.vsslib.imfilters import image_weighted_merge
from vsdeoldify.vsslib.constants import *
from vsdeoldify.vsslib.vsutils import MessageType, HAVC_LogMessage, debug_ModifyFrame

os.environ["CUDA_DEVICE_ORDER"] = "PCI_BUS_ID"
os.environ["CUDA_VISIBLE_DEVICES"] = "0"
os.environ["CUDA_MODULE_LOADING"] = "LAZY"

# torch.cuda.set_device(0)

# import warnings

# weights are not duplicated
package_dir = path.dirname(os.path.realpath(__file__)).replace("colormnet2", "colormnet")


def vs_colormnet2_local(clip: vs.VideoNode, clip_ref: vs.VideoNode, clip_sc: vs.VideoNode, image_size: int = -1,
                       enable_resize: bool = False, frame_propagate: bool = False, render_vivid: bool = True,
                       max_memory_frames: int = 0, ref_weight: float = 1.0, use_all_refs: bool = False) -> vs.VideoNode:
    vid_length = clip.num_frames

    colorizer = ColorMNetRender2(image_size=image_size, vid_length=vid_length, enable_resize=enable_resize,
                                encode_mode=1, max_memory_frames=max_memory_frames, reset_on_ref_update=render_vivid,
                                project_dir=package_dir)

    clip_colored = _colormnet2_async(colorizer, clip, clip_ref, clip_sc, frame_propagate, ref_weight, use_all_refs)

    return clip_colored


def _colormnet2_async(colorizer: ColorMNetRender2, clip: vs.VideoNode, clip_ref: vs.VideoNode, clip_sc: vs.VideoNode,
                     frame_propagate: bool = False, ref_weight: float = 1.0,
                     use_all_refs: bool = False) -> vs.VideoNode:

    reader: RefImageReader2 = RefImageReader2(use_all_refs=use_all_refs)

    if use_all_refs:
        reader.load_clip_ref(clip_ref, clip_sc)

    def colormnet_clip_color_merge(n, f, reader: RefImageReader2, colorizer: ColorMNetRender2 = None,
                                   propagate: bool = False, weight: float = 1.0) -> vs.VideoFrame:

        is_scenechange = f[2].props['_SceneChangePrev'] == 1
        is_scenechange_ext = is_scenechange and f[2].props['_SceneChangeNext'] == 1
        img_orig = frm_to_img(f[0])
        img_ref = frm_to_img(f[1])  # must always be same as video to be merged, even if frame_as_video = False

        if reader.enabled():
            # if n > 1 and colorizer.get_frame_count() == 0:
            #    reader.reload_clip_ref(n - 1)
            ref_i = reader.get_next_ref_frame(n)
            colorizer.set_ref_frame(ref_i)
        else:
            if n == 0:
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref)
            elif is_scenechange:
                frame_as_video = not is_scenechange_ext and propagate
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref, frame_as_video)
            else:
                colorizer.set_ref_frame(None)

        img_color = colorizer.colorize_frame(ti=n, frame_i=img_orig)

        # the frames that are not scenechange are merged with the ref frames generated by HAVC
        # this should stabilize further the colors generated with HAVC.
        if not is_scenechange:
            img_color_m = image_weighted_merge(img_color, img_ref, weight)
        else:   # the frame obtained from a reference should be already good is merged with low weight
            img_color_m = img_color   # image_weighted_merge(img_color, img_ref, DEF_MERGE_LOW_WEIGHT)

        return img_to_frm(img_color_m, f[0].copy())

    def colormnet_clip_color(n, f, reader: RefImageReader2, colorizer: ColorMNetRender2 = None,
                             propagate: bool = False) -> vs.VideoFrame:

        is_scenechange = f[1].props['_SceneChangePrev'] == 1
        is_scenechange_ext = f[1].props['_SceneChangeNext'] == 1
        img_orig = frm_to_img(f[0])

        if reader.enabled():
            # if n > 1 and colorizer.get_frame_count() == 0:
            #    reader.reload_clip_ref(n - 1)
            ref_i = reader.get_next_ref_frame(n)
            colorizer.set_ref_frame(ref_i)
        else:
            if n == 0:
                img_ref = frm_to_img(f[1])
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref)
            elif is_scenechange:
                img_ref = frm_to_img(f[1])
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                frame_as_video = not is_scenechange_ext and propagate
                colorizer.set_ref_frame(img_ref, frame_as_video)
            else:
                colorizer.set_ref_frame(None)

        img_color = colorizer.colorize_frame(ti=n, frame_i=img_orig)

        return img_to_frm(img_color, f[0].copy())

    if 0 < ref_weight < 1 and not (clip_sc is None):
        clip_colored = clip.std.ModifyFrame(clips=[clip, clip_ref, clip_sc],
                                            selector=partial(colormnet_clip_color_merge, reader=reader,
                                                     colorizer=colorizer, propagate=frame_propagate, weight=ref_weight))

        #clip_colored = debug_ModifyFrame(0, 640, clip, clips=[clip, clip_ref, clip_sc],
        #                                 selector=partial(colormnet_clip_color_merge, reader=reader,
        #                                          colorizer=colorizer, propagate=frame_propagate, weight=ref_weight))
    else:
        clip_colored = clip.std.ModifyFrame(clips=[clip, clip_ref],
                                            selector=partial(colormnet_clip_color, reader=reader, colorizer=colorizer,
                                                             propagate=frame_propagate))
        #clip_colored = debug_ModifyFrame(0, 100, clip, clips=[clip, clip_ref],
        #                                 selector=partial(colormnet_clip_color, reader=reader, colorizer=colorizer,
        #                                                  propagate=frame_propagate))
    return clip_colored


def vs_colormnet2_remote(clip: vs.VideoNode, clip_ref: vs.VideoNode, clip_sc: vs.VideoNode, image_size: int = -1,
                        enable_resize: bool = False, frame_propagate: bool = False, render_vivid: bool = True,
                        max_memory_frames: int = 0, ref_weight: float = 1.0, use_all_refs: bool = False,
                        server_port: int = 0) -> vs.VideoNode:
    vid_length = clip.num_frames

    server = ColorMNetServer2(server_port=server_port).run_server()
    colorizer = ColorMNetClient2(image_size=image_size, vid_length=vid_length, enable_resize=enable_resize,
                                encode_mode=0, max_memory_frames=max_memory_frames, reset_on_ref_update=render_vivid,
                                server_port=server.get_port())

    if not colorizer.is_initialized():
        HAVC_LogMessage(MessageType.EXCEPTION, "Failed to initialize ColorMNet[remote] try ColorMNet[local]")

    clip_colored = _colormnet2_client(colorizer, clip, clip_ref, clip_sc, frame_propagate, ref_weight, use_all_refs)

    return clip_colored


def _colormnet2_client(colorizer: ColorMNetClient2, clip: vs.VideoNode, clip_ref: vs.VideoNode, clip_sc: vs.VideoNode,
                      frame_propagate: bool = False, ref_weight: float = 1.0,
                      use_all_refs: bool = False) -> vs.VideoNode:
    reader: RefImageReader2 = RefImageReader2(use_all_refs=use_all_refs)

    if use_all_refs:
        reader.load_clip_ref(clip_ref, clip_sc)

    def colormnet_client_color_merge(n, f, reader: RefImageReader2, colorizer: ColorMNetClient2 = None,
                                     propagate: bool = False, weight: float = 1.0) -> vs.VideoFrame:

        is_scenechange = f[2].props['_SceneChangePrev'] == 1
        is_scenechange_ext = is_scenechange and f[2].props['_SceneChangeNext'] == 1
        img_orig = frm_to_img(f[0])
        img_ref = frm_to_img(f[1])  # must always be same as video to be merged, even if frame_as_video = False

        if reader.enabled():
            # if n > 1 and colorizer.get_frame_count() == 0:
            #    reader.reload_clip_ref(n - 1)
            ref_i = reader.get_next_ref_frame(n)
            colorizer.set_ref_frame(ref_i)
        else:
            if n == 0:
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref)
            elif is_scenechange:
                frame_as_video = not is_scenechange_ext and propagate
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref, frame_as_video)
            else:
                colorizer.set_ref_frame(None)

        img_color = colorizer.colorize_frame(ti=n, frame_i=img_orig)

        # the frames that are not scenechange are merged with the ref frames generated by HAVC
        # this should stabilize further the colors generated with HAVC.
        if not is_scenechange:
            img_color_m = image_weighted_merge(img_color, img_ref, weight)
        else:   # the frame obtained from a reference should be already good is merged with low weight
            img_color_m = img_color   # image_weighted_merge(img_color, img_ref, DEF_MERGE_LOW_WEIGHT)

        return img_to_frm(img_color_m, f[0].copy())

    def colormnet_client_color(n, f, reader: RefImageReader2, colorizer: ColorMNetClient2 = None,
                               propagate: bool = False) -> vs.VideoFrame:

        is_scenechange = f[1].props['_SceneChangePrev'] == 1
        is_scenechange_ext = f[1].props['_SceneChangeNext'] == 1
        img_orig = frm_to_img(f[0])

        if reader.enabled():
            # if n > 1 and colorizer.get_frame_count() == 0:
            #    reader.reload_clip_ref(n - 1)
            ref_i = reader.get_next_ref_frame(n)
            colorizer.set_ref_frame(ref_i)
        else:
            if n == 0:
                img_ref = frm_to_img(f[1])
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                colorizer.set_ref_frame(img_ref)
            elif is_scenechange:
                img_ref = frm_to_img(f[1])
                # vs.core.log_message(2, "Reference Frame: " + str(n))
                frame_as_video = not is_scenechange_ext and propagate
                colorizer.set_ref_frame(img_ref, frame_as_video)
            else:
                colorizer.set_ref_frame(None)

        img_color = colorizer.colorize_frame(ti=n, frame_i=img_orig)

        return img_to_frm(img_color, f[0].copy())

    if 0 < ref_weight < 1 and not (clip_sc is None):
        clip_colored = clip.std.ModifyFrame(clips=[clip, clip_ref, clip_sc],
                                            selector=partial(colormnet_client_color_merge, reader=reader,
                                                             colorizer=colorizer, propagate=frame_propagate,
                                                             weight=ref_weight))
    else:
        clip_colored = clip.std.ModifyFrame(clips=[clip, clip_ref],
                                            selector=partial(colormnet_client_color, reader=reader, colorizer=colorizer,
                                                             propagate=frame_propagate))
    return clip_colored

