import dlib
import sys

print("=== Verifica CUDA in dlib ===")
print(f"DLIB_USE_CUDA: {dlib.DLIB_USE_CUDA}")
print(f"Numero GPU rilevate: {dlib.cuda.get_num_devices()}")

if not dlib.DLIB_USE_CUDA:
    print("❌ ERRORE: dlib compilato senza supporto CUDA")
    sys.exit(1)

if dlib.cuda.get_num_devices() == 0:
    print("❌ ERRORE: CUDA abilitato ma nessuna GPU rilevata")
    print("   → Verifica che i driver NVIDIA siano aggiornati")
    sys.exit(1)

print("✅ CUDA ATTIVATO e GPU rilevata")

# Test 1: Imposta dispositivo CUDA corrente
try:
    dlib.cuda.set_device(0)
    print("✅ Dispositivo CUDA 0 impostato correttamente")
except Exception as e:
    print(f"⚠️  set_device(0) non supportato: {e}")

# Test 2: Verifica disponibilità GPU per operazioni (richiede un modello CNN)
try:
    # Prova a caricare un modello CNN (se disponibile nella cartella corrente)
    detector = dlib.cnn_face_detection_model_v1("mmod_human_face_detector.dat")
    print("✅ Modello CNN caricato con successo (conferma uso CUDA)")
    
    # Test su immagine fittizia (512x512 RGB)
    import numpy as np
    fake_image = np.random.randint(0, 255, (512, 512, 3), dtype=np.uint8)
    faces = detector(fake_image, 1)
    print(f"✅ Operazione CNN eseguita su GPU: rilevati {len(faces)} 'volti' (immagine casuale)")
    
except FileNotFoundError:
    print("ℹ️  Modello CNN non trovato (models/mmod_human_face_detector.dat)")
    print("   → Per test completo: scarica il modello da https://github.com/davisking/dlib-models")
    print("   → Comando rapido: curl -L -o models/mmod_human_face_detector.dat.bz2 https://github.com/davisking/dlib-models/raw/master/mmod_human_face_detector.dat.bz2")
    print("   → Poi decomprimi: bzip2 -d models/mmod_human_face_detector.dat.bz2")
except Exception as e:
    print(f"⚠️  Errore durante test CNN: {e}")

print("\n✅ VERIFICA COMPLETATA: dlib usa CUDA sulla tua RTX 5070 Ti")
