# Copyright (C) 2020  Davis E. King (davis@dlib.net)
# License: Boost Software License   See LICENSE.txt for the full license.
# Modified version for search torch cuda libraries by Dan64 (2026-02-15)
import os
import sys

def add_lib_to_dll_path(path):
    """On Windows you must call os.add_dll_directory() to allow linking to external DLLs.  See
    https://docs.python.org/3.8/whatsnew/3.8.html#bpo-36085-whatsnew.  This function adds the folder
    containing path to the dll search path.
    """
    try:
        # Work out where the various bin folders that hold nvidia's dlls are.
        lib_folder = os.path.dirname(path)
        dll_folder = lib_folder.replace("/lib/", "/bin/")
        if os.path.isdir(dll_folder):
            os.add_dll_directory(dll_folder)
        else:
            os.add_dll_directory(os.path.dirname(dll_folder))
    except (AttributeError, KeyError, FileNotFoundError):
        pass

def add_torch_lib_to_dll_path():
    """Add torch/lib folder to DLL search path on Windows."""
    try:
        import torch
        torch_lib_path = os.path.join(os.path.dirname(torch.__file__), 'lib')
        if os.path.isdir(torch_lib_path):
            os.add_dll_directory(torch_lib_path)
    except (ImportError, AttributeError, KeyError, FileNotFoundError):
        pass

if os.name == 'nt':  # Windows only
    # Try to add torch/lib to DLL search path
    add_torch_lib_to_dll_path()

from _dlib_pybind11 import *
from _dlib_pybind11 import __version__, __time_compiled__